	function H = PZ_2_FREQ_Z(G, Z, P, wT)

	% 	Computes the frequency response for a digital filter.

	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars wanhammar, 2007-10-10
	% 	Modified by: 	LW 2010-09-18
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com

		expiwT = exp(i*wT);
		H = ones(1,length(expiwT));
		for n = 1:length(Z)
			H = H.*(expiwT - Z(n));    
		end
		for n = 1:length(P)
			H = H./(expiwT - P(n));    
		end
		H = G*H;
